<?php
// ================= CONFIG =================
$BOT_TOKEN = "PUT_YOUR_BOT_TOKEN_HERE";
$STEAM_API_KEY = "PUT_YOUR_STEAM_API_KEY_HERE"; // برای پروفایل/بازی‌ها لازم

// ================= HELPERS =================
function tg($method, $data){
    global $BOT_TOKEN;
    file_get_contents("https://api.telegram.org/bot$BOT_TOKEN/$method?" . http_build_query($data));
}

// ================= REGIONS =================
$regions = [
    "global"=>["cc"=>"us","currency"=>"USD","title"=>"🌍 گلوبال"],
    "us"=>["cc"=>"us","currency"=>"USD","title"=>"🇺🇸 آمریکا"],
    "uk"=>["cc"=>"gb","currency"=>"GBP","title"=>"🇬🇧 انگلیس"],
    "eu"=>["cc"=>"de","currency"=>"EUR","title"=>"🇪🇺 اروپا"],
    "tr"=>["cc"=>"tr","currency"=>"TRY","title"=>"🇹🇷 ترکیه"],
    "ar"=>["cc"=>"ar","currency"=>"ARS","title"=>"🇦🇷 آرژانتین"],
    "ru"=>["cc"=>"ru","currency"=>"RUB","title"=>"🇷🇺 روسیه"],
    "cn"=>["cc"=>"cn","currency"=>"CNY","title"=>"🇨🇳 چین"],
    "ua"=>["cc"=>"ua","currency"=>"UAH","title"=>"🇺🇦 اوکراین"],
];

// ================= STEAM API =================
function resolveVanity($v){
    global $STEAM_API_KEY;
    $url = "https://api.steampowered.com/ISteamUser/ResolveVanityURL/v1/?key=$STEAM_API_KEY&vanityurl=$v";
    $res = json_decode(file_get_contents($url), true);
    return $res['response']['steamid'] ?? false;
}

function getProfile($steamid){
    global $STEAM_API_KEY;
    $url = "https://api.steampowered.com/ISteamUser/GetPlayerSummaries/v2/?key=$STEAM_API_KEY&steamids=$steamid";
    $res = json_decode(file_get_contents($url), true);
    return $res['response']['players'][0] ?? false;
}

function getGames($steamid){
    global $STEAM_API_KEY;
    $url = "https://api.steampowered.com/IPlayerService/GetOwnedGames/v1/?key=$STEAM_API_KEY&steamid=$steamid&include_appinfo=1";
    $res = json_decode(file_get_contents($url), true);
    return $res['response']['games'] ?? [];
}

// ================= STEAM STORE DISCOUNTS =================
function getDiscountedGames($cc){
    $url = "https://store.steampowered.com/api/featuredcategories?cc=$cc";
    $res = json_decode(file_get_contents($url), true);
    return $res['specials']['items'] ?? [];
}

// ================= KEYBOARD HELPERS =================
function regionKeyboard($regions){
    $keyboard = [];
    foreach($regions as $key => $r){
        $keyboard[] = [["text"=>$r['title'], "callback_data"=>"region_$key"]];
    }
    return json_encode(["inline_keyboard"=>$keyboard]);
}

function mainMenu(){
    return json_encode([
        "inline_keyboard"=>[
            [["text"=>"👤 پروفایل استیم","callback_data"=>"profile"]],
            [["text"=>"🎮 بازی‌های اکانت","callback_data"=>"games"]],
            [["text"=>"🚩 ریپورت","callback_data"=>"report"]],
            [["text"=>"🎁 تخفیف‌های استیم","callback_data"=>"discounts"]]
        ]
    ]);
}

// ================= TELEGRAM UPDATE =================
$update = json_decode(file_get_contents("php://input"), true);
$message = $update['message'] ?? null;
$callback = $update['callback_query'] ?? null;
$chat = $message['chat']['id'] ?? $callback['message']['chat']['id'] ?? null;

// ================= HANDLE MESSAGES =================
if($message && ($message['text'] ?? '') === '/start'){
    tg('sendMessage',[
        'chat_id'=>$chat,
        'text'=>"🤖 ربات استیم",
        'reply_markup'=>mainMenu()
    ]);
    exit;
}

// ================= HANDLE CALLBACKS =================
if($callback){
    $data = $callback['data'];
    
    // Profile / Games / Report / Discounts
    if(in_array($data, ['profile','games','report','discounts'])){
        file_put_contents("state_$chat.txt",$data);
        if($data === 'discounts'){
            tg('sendMessage',[
                'chat_id'=>$chat,
                'text'=>"🎯 ریجن خود را انتخاب کنید:",
                'reply_markup'=>regionKeyboard($regions)
            ]);
        } else {
            tg('sendMessage',[
                'chat_id'=>$chat,
                'text'=>"لطفاً SteamID یا Vanity ID خود را ارسال کنید:"
            ]);
        }
        exit;
    }

    // Region selected for discounts
    if(strpos($data,"region_")===0){
        $key = str_replace("region_","",$data);
        $r = $regions[$key] ?? null;
        if(!$r) exit;

        $games = getDiscountedGames($r['cc']);
        $text = "🔥 تخفیف‌های ".$r['title']."\n\n";
        $i = 0;
        foreach($games as $g){
            if($i>=5) break;
            $price = $g['final_price']/100;
            $old = $g['original_price']/100;
            $disc = $g['discount_percent'];
            $text .= "🎮 {$g['name']}\n🔻 {$disc}% | 💰 $old → $price {$r['currency']}\n🔗 https://store.steampowered.com/app/{$g['id']}\n\n";
            $i++;
        }
        tg('sendMessage',[
            'chat_id'=>$chat,
            'text'=>$text
        ]);
        exit;
    }
}

// ================= HANDLE STEAM ID MESSAGE =================
if($message && file_exists("state_$chat.txt")){
    $state = trim(file_get_contents("state_$chat.txt"));
    unlink("state_$chat.txt");
    $input = trim($message['text']);
    $steamid = is_numeric($input) ? $input : resolveVanity($input);
    if(!$steamid){
        tg('sendMessage',['chat_id'=>$chat,'text'=>"❌ آیدی نامعتبر","reply_markup"=>mainMenu()]);
        exit;
    }
    $profile = getProfile($steamid);
    if(!$profile){
        tg('sendMessage',['chat_id'=>$chat,'text'=>"❌ پروفایل پیدا نشد","reply_markup"=>mainMenu()]);
        exit;
    }

    if($state==='profile'){
        $created = $profile['timecreated'] ?? null;
        $years = $created ? floor((time()-$created)/31536000) : 'Private';
        $statusMap=[0=>'آفلاین',1=>'آنلاین',2=>'مشغول',3=>'دور',4=>'Snooze',5=>'دنبال معامله',6=>'دنبال بازی'];
        $status = $statusMap[$profile['personastate']] ?? 'نامشخص';
        $caption = "👤 <b>{$profile['personaname']}</b>\n🆔 <code>{$steamid}</code>\n📅 سن اکانت: {$years} سال\n📡 وضعیت: {$status}\n🌍 کشور: ".($profile['loccountrycode'] ?? 'نامشخص');
        tg('sendPhoto',[
            'chat_id'=>$chat,
            'photo'=>$profile['avatarfull'],
            'caption'=>$caption,
            'parse_mode'=>'HTML',
            'reply_markup'=>mainMenu()
        ]);
        exit;
    }

    if($state==='games'){
        $gamesList = getGames($steamid);
        if(!$gamesList){
            tg('sendMessage',['chat_id'=>$chat,'text'=>"❌ پروفایل Private است","reply_markup"=>mainMenu()]);
            exit;
        }
        $out = "🎮 5 بازی برتر:\n";
        foreach(array_slice($gamesList,0,5) as $g){
            $hours = round($g['playtime_forever']/60,1);
            $out .= "• {$g['name']} - {$hours} ساعت\n";
        }
        tg('sendMessage',['chat_id'=>$chat,'text'=>$out,'reply_markup'=>mainMenu()]);
        exit;
    }

    if($state==='report'){
        tg('sendMessage',[
            'chat_id'=>$chat,
            'text'=>"🚩 لینک ریپورت رسمی:\nhttps://steamcommunity.com/profiles/$steamid/report",
            'reply_markup'=>mainMenu()
        ]);
        exit;
    }
}
?>
